package w83b.w83bOperacionesInternas.w83bMantenimientos.w83bDelegaciones;

import w83b.w83bBeans.W83bDelegacionesBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
/**
 * 
 * @author jrgil
 *
 */
public class W83bMovimientoDelegacionesOIAction extends Q70OperacionInterna{
	/**
	 * preProcessMappingEntrada
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
				
		
		W83bDelegacionesBean delegacionesBean = (W83bDelegacionesBean)contexto.get("w83bDelegacionesNuevoBean");
		if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equalsIgnoreCase(delegacionesBean.getCodTerritorio())){
			if(W83bClsConstantes.CONSTANTE_VITORIA.equalsIgnoreCase(delegacionesBean.getLocalidad())){
				delegacionesBean.setCodServCent(W83bClsConstantes.CONSTANTE_ALAVA);
			}else if(W83bClsConstantes.CONSTANTE_BILBAO.equalsIgnoreCase(delegacionesBean.getLocalidad())){
				delegacionesBean.setCodServCent(W83bClsConstantes.CONSTANTE_BIZKAIA);
			}else if(W83bClsConstantes.CONSTANTE_DONOSTIA.equalsIgnoreCase(delegacionesBean.getLocalidad())){
				delegacionesBean.setCodServCent(W83bClsConstantes.CONSTANTE_GIPUZKOA);
			}else{
				delegacionesBean.setCodServCent(delegacionesBean.getCodTerritorio());
			}
		}else{
			delegacionesBean.setCodServCent(delegacionesBean.getCodTerritorio());
		}
		delegacionesBean.setModo((String)contexto.get("modoPantalla"));
		super.preProcessMappingEntrada(contexto, configBean, errors);	
	
	}
	/**
	 * postProcessMappingSalida
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
		
		
		String resultado = (String)contexto.get("w83bResultado");
		if("-1".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.existeRegistroTerritorio", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else{
			
			contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOk");
			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			contexto.set("strTitleKey","comun.delegaciones.editarDelegaciones");
		}


		super.postProcessMappingSalida(contexto, errors);
	}
	
}
